document.addEventListener("DOMContentLoaded", () => {
  const hamburger = document.querySelector(".hamburger");
  const navMenu = document.querySelector(".nav-menu");
  const userIcon = document.querySelector(".user-icon");
  const modal = document.getElementById("loginModal");
  const closeModal = document.querySelector(".close");
  const modalChoice = document.getElementById("modalChoice");
  const modalLogin = document.getElementById("modalLogin");
  const loginFormBtn = document.getElementById("loginFormBtn");
  const externalLinkBtn = document.getElementById("externalLinkBtn");

  // Hamburger menu
  if (!hamburger) console.error("Hamburger button not found");
  if (!navMenu) console.error("Nav menu not found");

  hamburger.addEventListener("click", () => {
    navMenu.classList.toggle("active");
    console.log("Hamburger clicked");
  });

  const menuItems = document.querySelectorAll(".nav-menu > li");
  menuItems.forEach((item) => {
    item.addEventListener("click", (e) => {
      if (window.innerWidth <= 790 && !item.classList.contains("user-icon")) {
        e.stopPropagation();
        menuItems.forEach((otherItem) => {
          if (otherItem !== item && otherItem.classList.contains("active")) {
            otherItem.classList.remove("active");
          }
        });
        item.classList.toggle("active");
      }
    });
  });

  // Buka modal dengan tampilan pilihan
  userIcon.addEventListener("click", (e) => {
    e.preventDefault();
    modal.style.display = "block";
    modalChoice.style.display = "flex"; // Tampilkan pilihan
    modalLogin.style.display = "none"; // Sembunyikan form
  });

  // Tutup modal
  closeModal.addEventListener("click", () => {
    modal.style.display = "none";
  });

  window.addEventListener("click", (event) => {
    if (event.target === modal) {
      modal.style.display = "none";
    }
  });

  // Tombol Login dengan Username
  loginFormBtn.addEventListener("click", () => {
    modalChoice.style.display = "none"; // Sembunyikan pilihan
    modalLogin.style.display = "block"; // Tampilkan form
  });

  // Tombol Login Eksternal (arah ke link)
  externalLinkBtn.addEventListener("click", () => {
    window.location.href = "https://example.com/login"; // Ganti dengan link Anda
  });

  // Form submission (opsional, tambahkan logika Anda)
  const loginForm = document.getElementById("loginForm");
  loginForm.addEventListener("submit", (e) => {
    e.preventDefault();
    console.log("Login submitted");
    // Tambahkan logika autentikasi di sini
    modal.style.display = "none";
  });

  // Sesuaikan tinggi nav menu
  function adjustNavMenuHeight() {
    if (window.innerWidth <= 790) {
      const navbarHeight = document.querySelector(".navbar").offsetHeight;
      const windowHeight = window.innerHeight;
      const maxHeight = windowHeight - navbarHeight - 10;
      navMenu.style.maxHeight = `${maxHeight}px`;
    } else {
      navMenu.style.maxHeight = "";
    }
  }

  window.addEventListener("load", adjustNavMenuHeight);
  window.addEventListener("resize", adjustNavMenuHeight);
});
